#include <itpp/itbase.h>
#include <estim/libPF.h>
#include <math/libDC.h>
#include <stat/libEF.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RV x("1");
	RV xm=x; xm.t(-1);
	RV y("2");
	
	mat A = "1";
	vec vR = "1";
	ldmat R(vR);
	
	
	vec ptc = randn(10);
	vec w = exp(-0.5*(pow(ptc,2))/0.2);
	
	cout << "p:" << ptc << endl;
	cout << "w:" << w << endl;
	
	PF pf(w);
	ivec ind = pf.resample();
	
	cout << ind << endl;
	/*
	mlnorm<ldmat> obs(x,xm,A,R);
	mlnorm<ldmat> par(y,x,A,R);
	
	TrivialPF TPF(obs,par,10);
	*/
	//Exit program:
	return 0;

}
