#include "libPF.h"

using namespace itpp;

using std::endl;

void PF::bayes ( const vec &dt ) {
	int i;
	vec lls ( n );
	ivec ind;
	double mlls=-std::numeric_limits<double>::infinity(), sum=0.0;

	for ( i=0;i<n;i++ ) {
		//generate new samples from paramater evolution model;
		_samples ( i ) = par.samplecond ( _samples ( i ), lls ( i ) );
		lls ( i ) *= obs.evallogcond ( dt,_samples ( i ) );

		if ( lls ( i ) >mlls ) mlls=lls ( i ); //find maximum
	}

	// compute weights
	for ( i=0;i<n;i++ ) {
		_w ( i ) *= exp ( lls ( i ) - mlls ); // multiply w by likelihood
	}

	//renormalize
	for ( i=0;i<n;i++ ) {sum+=_w ( i );};

	_w ( i ) /=sum; //?

	ind = est.resample();

}

void PF::set_est ( const epdf &epdf0 ) {
	int i;

	for ( i=0;i<n;i++ ) {
		_samples ( i ) = epdf0.sample();
	}
}

//MPF::MPF:{}
