#include <itpp/itbase.h>
#include "../bdm/stat/libBM.h"
#include "../bdm/math/libDC.h"
#include "../bdm/math/chmat.h"

#include <vector>
using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main()
{
	RV th = RV ( "{a b }");
	RV r = RV ( "{r1 r2 }" );

	cout << th << r << endl;

	ldmat ld = ldmat("1 0 0 0; 0.2 1 0 0; 0.1 -0.1 1 0; -0.9 0.3 -0.1 1",
					 "3 4 5 6");
	vec v = "1 -1 3 -1";
		
	cout << "Test to_mat"<<endl;
//	cout << ld << endl;
	mat L = ld.to_mat();
	cout << L <<endl;

	cout << "Test opupdt" <<endl;
	cout << "w=1" <<endl;
	ldmat ldup = ld;
	ldup.opupdt(v,1);
	cout << ldup.to_mat()<<endl;
	cout << L + outer_product(v,v) <<endl;
	ldup = ld;	
	cout << "w=0.1" <<endl;
	ldup.opupdt(v,0.1);
	cout << ldup.to_mat()<<endl;
	cout << L + 0.1*outer_product(v,v) <<endl;

	cout << "Test +="<<endl;
	ldmat ld2x = ld;
	ld2x+=ld;
	cout << ld.to_mat() <<endl << ld2x.to_mat() <<endl;

	cout << "Test *="<<endl;
	ld2x = ld;
	ld2x*=2;
	cout << ld.to_mat() <<endl << ld2x.to_mat() <<endl;
	
	cout << "Test ldinv()"<<endl;
	ldmat Il = ld; 
	ld.inv(Il); // 
	mat I = Il.to_mat()*ld.to_mat();
	cout << "ld:" << endl << Il.to_mat() << "eye:" << endl<< I <<endl;
	getchar();

	cout << "Test ldform()"<<endl;
	mat V = "1 2; 2 13"; 
	ldmat lV(V);
	ldmat ilV(V);  
	lV.inv(ilV);
	cout << "ld:" << lV << "eye:"<< V*(ilV.to_mat()) <<endl;

	cout << "Test logdet()"<<endl;
	chmat chV(V);
	cout << "ch:" << chV.to_mat() <<endl;
	cout << "log(det(V)):"<< chV.logdet() <<endl;
	cout << "qform : " << chV.qform(ones(2)) <<endl;
	

	//Exit program:
	getchar();
	return 0;

}
