#include <itpp/itbase.h>
#include <stat/libEF.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	//RNG_randomize();

	RV rv("1","{x }","2","0","0");
	int N = 10000; //number of samples
	vec mu0 = "1.5 1.7";
	mat V0("1.2 0.3; 0.3 5");
	ldmat R = ldmat(V0);
	enorm<ldmat> eN(rv,mu0,R);
	
	mat Smp = eN.sample(N);
	cout << "True:" <<endl;
	cout << "mu:" << mu0 ;
	cout << "R:" << R ;
	cout << "R:" << R.to_mat() ;
	
	vec Emu = Smp*ones(N) /N ;
	cout << "Empirical:" <<endl;
	cout << "mu:" << Emu;
	cout << "R:" << (Smp*Smp.transpose())/N - Emu*Emu.transpose() <<endl;

	//Exit program:
	return 0;

}
