/*
  \file
  \brief Common simulation profiles for PMSM experiments
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

void sim_profile_steps1(double &Ww,bool load=false) {

        if (t>0.2) x[8]=1.2;    // 1A //0.2ZP
        if (t>0.4) x[8]=10.8;   // 9A
        if (t>0.6) x[8]=25.2;  // 21A

        if (t>0.7) Ww=2.*M_PI*10.;
        if (t>1.0) x[8]=1.2;    // 1A
        if (t>1.2) x[8]=10.8;   // 9A
        if (t>1.4) x[8]=25.2;  // 21A

        if (t>1.6) Ww=2.*M_PI*50.;
        if (t>1.9) x[8]=1.2;    // 1A
        if (t>2.1) x[8]=10.8;   // 9A
        if (t>2.3) x[8]=25.2;  // 21A

        if (t>2.5) Ww=2.*M_PI*100;
        if (t>2.8) x[8]=1.2;    // 1A
        if (t>3.0) x[8]=10.8;   // 9A
        if (t>3.2) x[8]=25.2;  // 21A

        if (t>3.4) Ww=2.*M_PI*150;
        if (t>3.7) x[8]=1.2;    // 1A
        if (t>3.9) x[8]=10.8;   // 9A
        if (t>4.1) x[8]=25.2;  // 21A

        if (t>4.3) Ww=2.*M_PI*0;
        if (t>4.8) x[8]=-1.2;    // 1A
        if (t>5.0) x[8]=-10.8;   // 9A
        if (t>5.2) x[8]=-25.2;  // 21A

        if (t>5.4) Ww=2.*M_PI*(-10.);
        if (t>5.7) x[8]=-1.2;    // 1A
        if (t>5.9) x[8]=-10.8;   // 9A
        if (t>6.1) x[8]=-25.2;  // 21A

        if (t>6.3) Ww=2.*M_PI*(-50.);
        if (t>6.7) x[8]=-1.2;    // 1A
        if (t>6.9) x[8]=-10.8;   // 9A
        if (t>7.1) x[8]=-25.2;  // 21A

        if (t>7.3) Ww=2.*M_PI*(-100.);
        if (t>7.7) x[8]=-1.2;    // 1A
        if (t>7.9) x[8]=-10.8;   // 9A
        if (t>8.1) x[8]=-25.2;  // 21A
        if (t>8.3) x[8]=10.8;   // 9A
        if (t>8.5) x[8]=25.2;  // 21A
        
        if (t>9) Ww=2.*M_PI*0;
        //remove load if load=false
        if (!load) x[8]=0.0;
}

void sim_profile_2slowrevs(double &Ww,bool load=false) {
	static int k_rampa=1;

	if ((t>0.2)&&(t<0.8)) {
		if ((t>0.4)&&(t<0.7))
		 	Ww+=k_rampa*2.*M_PI*4e-5;    //1000Hz/s
		else
			Ww-=k_rampa*2.*M_PI*4e-5;    //1000Hz/s
	}	
	
	if (!load) x[8]=0.0;
}

void sim_profile_vec01t(double &Ww, vec &vecWw){
	static int ind=0;
	static double dW;
	if (t>=0.1*ind) {
		ind++;
		dW = vecWw(ind)-vecWw(ind-1);
	}
	Ww=vecWw(ind-1)+(t-0.1*(ind-1))*dW/0.1;
}