#include <libconfig.h++>
#include <fstream>
#include <iostream>
#include <sstream>

#include <itpp/itbase.h>
#include "itppconf.h"

using namespace libconfig;
using namespace std;
using namespace itpp;

void prtS(Setting& S){
	const char *Name=S.getName();
	if (Name!=NULL) {cout << std::string(Name);}; 
	Setting::Type T=S.getType();
	switch (T) {
		case Setting::TypeArray:
			cout << endl;
			for(int i=0;i<S.getLength();i++){prtS(S[i]);};
			break;
		case Setting::TypeList:
			cout << endl;
			for(int i=0;i<S.getLength();i++){prtS(S[i]);};
			break;
		case Setting::TypeGroup:
			cout << endl;
			for(int i=0;i<S.getLength();i++){prtS(S[i]);}
			break;
		case Setting::TypeInt:
			cout << " = ";
			cout << int(S)<<endl;
			break;
		case Setting::TypeFloat:
			cout << " = ";
			cout << double(S)<<endl;
			break;
		case Setting::TypeString:
			cout << " = ";
			cout << (const char*)(S)<<endl;
			break;
		case Setting::TypeBoolean:
			cout << " = ";
			cout << bool(S)<<endl;
			break;
			default: {cout << "?";};
	}
}

int main(){

cout << "========" <<endl;

Config C;
C.readFile("testik.cfg");
Setting& S=C.getRoot();;
prtS(S);

vec x= getVec(S["application"]["misc"]["vec"]);
cout << x << endl;

return 0;
}
