#include <itpp/itbase.h>
#include "libFN.h"

using std::endl;
using namespace bdm;

bilinfn::bilinfn ( const RV &rvx0, const RV &rvu0, const mat &A0, const mat &B0 ) : diffbifn (A0.rows(), rvx0,rvu0 )
{
	//check input
	it_assert_debug ( ( A0.cols() ==dimx ) & ( A0.rows() ==B0.rows() ), "linfn:: wrong A" );
	it_assert_debug ( ( B0.cols() ==dimu ), "linfn:: wrong B" );

	// set dimensions
	dimy = A0.rows();

	//set internals
	A = A0;
	B = B0;
};

inline vec bilinfn::eval ( const  vec &x0, const vec &u0 )
{
	it_assert_debug ( x0.length() ==dimx, "linfn::eval Wrong xcond." );
	it_assert_debug ( u0.length() ==dimu, "linfn::eval Wrong ucond." );
	return A*x0+B*u0;
};
