#include "uibuilder.h"

namespace bdm{
	
UImap __uimap__;

void UIexternal::build(Setting &S, void** result) const{
	Config C;
	try{
		C.readFile((const char*)S["filename"]);
	} catch (...){
		it_error("File " + string((const char*)S["filename"]) + " not found or broken");
	}
	try {	
		Setting& remS=C.lookup((const char*)S["path"]);
		UIbuild(remS,result);
	}
	catch (...) { it_error("External field " + string(S.getPath()) + " not valid");
	}
	
};
UIREGISTER(UIexternal);

void UIinternal::build(Setting &S, void** result) const{
	try {	
		Setting* Stmp = &S;
		do {Stmp=&(Stmp->getParent());} while (!Stmp->isRoot());
		Setting& intS=Stmp->lookup((const char*)S["path"]);
		UIbuild(intS,result);
	}
	catch (...) { it_error("Internal field " + string(S.getPath()) + " not valid");
	}
	
};
UIREGISTER(UIinternal);

}
//UIexternal* UIexternal_instance =new UIexternal();