/*!
  \file
  \brief Simulation of disturbances in PMSM model, PWM and integration disturbances are distinguished
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#include <uibuilder.h>
#include <stat/libDS.h>
#include "pmsmDS.h"

#include <stat/loggers_ui.h>

using namespace bdm;
int main() {
	UIFile F("sim.txt");

	logger* L; 
	UIbuild(F.lookup("logger"),L);
	pmsmDS * DS;
	UIbuild(F.lookup("system"),DS);
	int Ndat;
	F.lookupValue("ndat",Ndat);
	// SET SIMULATOR

	DS->log_add(*L);
	L->init();
	
	for ( int tK=1;tK<Ndat;tK++ ) {
		DS->step();
		DS->logit(*L);
	}
	
	L->finalize(); 
	
	delete L;
	delete DS;
	return 0;
}

