#include "uibuilder.h"

namespace bdm{
	
UImap __uimap__;

bdmroot* UIexternal::build(Setting &S) const{
	Config C;
	bdmroot* tmp;
	try{
		C.readFile((const char*)S["filename"]);
	} catch (...){
		it_error("File " + string((const char*)S["filename"]) + " not found or broken");
	}
	try {	
		Setting& remS=C.lookup((const char*)S["path"]);
		UIbuild(remS,tmp);
	}
	catch (...) { it_error("External field " + string(S.getPath()) + " not valid");
	}
	return tmp;
};
UIREGISTER(UIexternal);

bdmroot* UIinternal::build(Setting &S) const{
	bdmroot* tmp;
	try {	
		Setting* Stmp = &S;
		do {Stmp=&(Stmp->getParent());} while (!Stmp->isRoot());
		Setting& intS=Stmp->lookup((const char*)S["path"]);
		UIbuild(intS,tmp);
	}
	catch (...) { it_error("Internal field " + string(S.getPath()) + " not valid");
	}
	return tmp;
};
UIREGISTER(UIinternal);

}
//UIexternal* UIexternal_instance =new UIexternal();