#include "uibuilder.h"

namespace bdm{
	
UImap __uimap__;

bdmroot* UIexternal::build(Setting &S) const{
	Config C;
	bdmroot* tmp;
	try{
		C.readFile((const char*)S["filename"]);
	} catch (...){
		it_error("File " + string((const char*)S["filename"]) + " not found or broken");
	}
	try {	
		Setting& remS=C.lookup((const char*)S["path"]);
		UIbuild(remS,tmp);
	}
	catch (...) { it_error("External field " + string(S.getPath()) + " not valid");
	}
	return tmp;
};
UIREGISTER(UIexternal);

bdmroot* UIinternal::build(Setting &S) const{
	bdmroot* tmp;
	try {	
		Setting* Stmp = &S;
		do {Stmp=&(Stmp->getParent());} while (!Stmp->isRoot());
		Setting& intS=Stmp->lookup((const char*)S["path"]);
		UIbuild(intS,tmp);
	}
	catch (...) { it_error("Internal field " + string(S.getPath()) + " not valid");
	}
	return tmp;
};
UIREGISTER(UIinternal);

	void UI_DBG ( Setting &S, const string &spc ) {
		const char *Name=S.getName();
		if ( Name!=NULL ) {cout << spc << std::string ( Name );};
		Setting::Type T=S.getType();
		switch ( T ) {
			case Setting::TypeArray:
				cout << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );};
				break;
			case Setting::TypeList:
				cout << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );};
				break;
			case Setting::TypeGroup:
				cout << endl;
				for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );}
				break;
			case Setting::TypeInt:
				cout << " = ";
				cout << int ( S ) <<endl;
				break;
			case Setting::TypeFloat:
				cout << " = ";
				cout << double ( S ) <<endl;
				break;
			case Setting::TypeString:
				cout << " = ";
				cout << ( const char* ) ( S ) <<endl;
				break;
			case Setting::TypeBoolean:
				cout << " = ";
				cout << bool ( S ) <<endl;
				break;
				default: {cout << "?";};
		}
	}

}
//UIexternal* UIexternal_instance =new UIexternal();