/*!
\file 
\brief Test of UI builders for ARX

See file \ref arx for mathematical background.

 */


#include <stat/libDS_ui.h>

using namespace bdm;
int main() {
	UIFile F("UIArxDS_test.cfg");

	logger* L; 
	UIbuild(F.lookup("logger"),L);
	ArxDS * DS;
	UIbuild(F.lookup("system"),DS);
	int Ndat;
	F.lookupValue("experiment.ndat",Ndat);
	// SET SIMULATOR

	DS->log_add(*L);
	L->init();
	
	for ( int tK=1;tK<Ndat;tK++ ) {
		DS->step();
		DS->logit(*L);
		L->step();
	}
	
	L->finalize(); 
	
	delete L;
	delete DS;
	return 0;
}

