/*!
  \file
  \brief UI builders for Loggers 
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef LGR_UI_H
#define LGR_UI_H

#include "loggers.h"
#include "uibuilder.h"

using namespace bdm;

class UIdirfilelog : public UIbuilder {
	public:
	UIdirfilelog():UIbuilder("dirfilelog"){};
	bdmroot* build(Setting &S) const{
		return new dirfilelog(S["dirname"],S["maxlen"]);
	};
};

UIREGISTER(UIdirfilelog);
#endif // LGR_H
