#include <itpp/itcomm.h>
#include <itpp/itmex.h>

#include <stat/libDS_ui.h>
#include <estim/arx_ui.h>

#include "mexlog.h"

using namespace bdm;

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	const char *fname;
	if (n_input>0){
		fname=mxArray2string(input[0]).c_str();
	} else {
		fname = "UIArxDS_test.cfg";
	}
	// ------------------ 
	
	UIFile F ( fname);

	logger* L;
	UIbuild ( F.lookup ( "logger" ),L );
	ArxDS * DS;
	UIbuild ( F.lookup ( "system" ),DS );
	int Ndat;
	F.lookupValue ( "experiment.ndat",Ndat );
	// SET SIMULATOR
	BM* E;
	UIbuild ( F.lookup ( "estimator" ),E );

	DS->log_add ( *L );
	int L_est= L->add ( E->_epdf()._rv(), "est" ); // estimate
	int L_lb = L->add ( E->_epdf()._rv(), "lb" ); // lower bound
	int L_ub = L->add ( E->_epdf()._rv(), "ub" ); // upper bound
	L->init();

	vec dt=zeros ( DS->_drv().count() );   //data variable
	datalink_e2e dl ( E->_drv(),DS->_drv() ); //datalink between a datasource and estimator

	for ( int tK=0;tK<Ndat;tK++ ) {
		DS->step();							// simulator step
		DS->getdata ( dt );					// read data
		E->bayes ( dl.get_val ( dt ) );		// update estimates

		DS->logit ( *L );
		L->logit ( L_est, E->_epdf().mean() );
		L->logit ( L_lb,  E->_epdf().mean()-2*sqrt ( E->_epdf().variance() ) );
		L->logit ( L_ub,  E->_epdf().mean() +2*sqrt ( E->_epdf().variance() ) );

		L->step();
	}

	L->finalize();
	
	
	// ------------------ End of routine -----------------------------
	
	mexlog* mL=dynamic_cast<mexlog*>(L);

	if (mL) { // user wants output!!
		if ( n_output<1 ) mexErrMsgTxt ( "Wrong number of output variables!" );
		output[0] = mL->toCell();
	}
	
	///////
	delete L;
	delete DS;
	delete E;

}
