
#include "libDS.h"

using namespace bdm;

void MemDS::getdata ( vec &dt ) {
	int i;

	it_assert_debug ( dt.length() ==rowid.length(), "MemDS:getdata incompatible dt" );
	for ( i=0;i<rowid.length();i++ ) {
		dt ( i ) = Data ( rowid ( i ),time-delays ( i ) );
	}
}

void MemDS::getdata ( vec &dt,const ivec &indeces ) {
	int j,i;
	it_assert_debug ( dt.length() ==indeces.length(), "MemDS:getdata incompatible dt" );
	for ( i=0;i<indeces.length();i++ ) {
		j = indeces ( i );
		dt ( i ) = Data ( rowid ( j ),time-delays ( j ) );
	}
}

void MemDS::step() {
	if ( time<Data.cols() ) {time++;}
}

void MemDS::linkrvs ( RV &drv, RV &urv ) {
	it_assert_debug ( drv.count() ==rowid.length(),"MemDS::linkrvs incompatible drv" );
	it_assert_debug ( urv.count() ==0,"MemDS does not support urv." );

	Drv = drv;
	Urv = urv;
}

MemDS::MemDS ( mat &Dat, ivec &rowid, ivec &delays ) {
	it_assert_debug ( max ( rowid ) <=Dat.rows(),"MemDS rowid is too high for given Dat." );
	it_assert_debug ( max ( delays ) <Dat.cols(),"MemDS delays are too high." );

	time = max ( delays );
	Data = Dat;
}

void ArxDS::step() {
	double tmp;
	//shift history
	H.shift_right ( 0, Drv.count() +Urv.count() );

	H.set_subvector ( Drv.count(), U ); // write U after Drv

	//get regressor
	rgr = rgrlnk.get_val ( H );
	// Eval Y
	H.set_subvector ( 0, model.samplecond ( rgr,tmp ) );

}

//! Auxiliary function building full history of rv0
RV fullrgr ( const RV &drv0, const RV &urv0, const RV &rrv0 ) {
	RV T ( urv0 );
	RV pom = concat ( drv0, urv0 );
	int mint = rrv0.mint();
	for ( int i=0; i>mint; i-- ) {
		pom.t ( -1 );
		T.add ( pom );
	}
	return T;
}

ArxDS::ArxDS ( RV &drv, RV &urv, RV &rrv ) :
		DS ( drv,urv ), Rrv ( rrv ), Hrv ( concat(drv,fullrgr ( drv,urv,rrv )) ), //RVs
		H ( Hrv.count() ) ,U ( urv.count() ),rgr ( rrv.count() ),  //tmp variables
		rgrlnk ( rrv, Hrv ) ,model ( drv,rrv ) {
}
