/*!
\file
\brief Test of UI builders for ARX

See file \ref arx for mathematical background.

 */


#include <stat/libDS_ui.h>
#include <estim/arx_ui.h>

using namespace bdm;
int main(int argc, char* argv[]) {
	const char *fname;
	if (argc>0) {
		fname = argv[0];
	} else {
		fname = "UIArxDS_test.cfg";
	}
	UIFile F ( fname );

	logger* L;
	UIbuild ( F.lookup ( "logger" ),L );
	ArxDS * DS;
	UIbuild ( F.lookup ( "system" ),DS );
	int Ndat;
	F.lookupValue ( "experiment.ndat",Ndat );
	// SET SIMULATOR
	BM* E;
	UIbuild ( F.lookup ( "estimator" ),E );

	DS->log_add ( *L );
	int L_est= L->add ( E->_epdf()._rv(), "est" ); // estimate
	int L_lb = L->add ( E->_epdf()._rv(), "lb" ); // lower bound
	int L_ub = L->add ( E->_epdf()._rv(), "ub" ); // upper bound
	L->init();

	vec dt=zeros ( DS->_drv().count() );   //data variable
	datalink_e2e dl ( E->_drv(),DS->_drv() ); //datalink between a datasource and estimator

	for ( int tK=1;tK<Ndat;tK++ ) {
		DS->step();							// simulator step
		DS->getdata ( dt );					// read data
		E->bayes ( dl.get_val ( dt ) );		// update estimates

		DS->logit ( *L );
		L->logit ( L_est, E->_epdf().mean() );
		L->logit ( L_lb,  E->_epdf().mean()-2*sqrt ( E->_epdf().variance() ) );
		L->logit ( L_ub,  E->_epdf().mean() +2*sqrt ( E->_epdf().variance() ) );

		L->step();
	}

	L->finalize();

	delete L;
	delete DS;
	delete E;
	return 0;
}

