
#include "loggers.h"
#include "../osutils.h"

#include <fcntl.h>
#ifdef WIN32
#include <io.h>
#endif

namespace bdm{
void memlog::itsave ( const char* fname ) {
	it_file itf ( fname );
	int i;
	for ( i=0; i<entries.length();i++ ) {
		if ( names ( i ).length() <1 ) {
			std::ostringstream o;
			o<<"Variable"<<i;
			itf << Name ( o.str() ) << vectors ( i );
		}
		else {
			itf << Name ( names ( i ) ) << vectors ( i );
		}
	}
}

void dirfilelog::init() {
	int i,j,k;
	int nsc=0;
	for ( i=0;i<entries.length();i++ ) {nsc+=entries ( i )._dsize();}
	; //all entries!!

	char filename[200];
	char num[3];

// Initialize directory
	makedir ( dirname ); //

// directory OK, or it can be overwritten

//Create filenames
	scalarnames.set_length ( nsc );
	// For all entries
	int ii=0;
	for ( i=0;i<entries.length();i++ ) { //for entries
		for ( j=0;j<entries ( i ).length();j++ ) { //for RVs in entries
			int rvsize = entries ( i ).size ( j );
			// for non-empty names
			if (names(i).length()>0) {scalarnames(ii)=names(i) + "_";}
			// add name
			scalarnames ( ii ) +=  entries ( i ).name ( j );
			// add number when needed
			if ( rvsize >1 ) {
				// copy the same name for th whole RV
				for ( k=1;k<rvsize;k++ ) {scalarnames(ii+k)=scalarnames(ii);}
				// add numbers
				for ( k=0;k<rvsize;k++ ) { //for all scalars in given RV
					sprintf ( num,"%d",k );
					scalarnames ( ii ) += (std::string)"_" + num;
					ii++;
				}
			} else {
			ii++;}
		}
	}
	//Create format
	string frm="format";
	get_fname ( filename, dirname, frm );

	FILE* fpf;
	fpf = fopen ( filename, "w" );
	for ( i=0;i<ii;i++ ) {
		fprintf ( fpf, "%s RAW d 1\n", scalarnames ( i ).c_str() );
	}
	fclose ( fpf );

	memlog::init();

	//Delete old data
	write_buffers ( 0 );
}


void dirfilelog::write_buffers ( int Len ) {
	int fp;
	int nen=entries.length(); //all entries!!
	double *Dt;
	int DtRows;
	int i,j,k;
	int ii; //index in scalarnames;
	int jj; //index in vectors()
	char filename[200];

	it_assert_debug ( Len<=maxlen,"diffilelog" );

	ii = 0;
	for ( i=0;i<nen;i++ ) { //for entries
		Dt = vectors ( i )._data();
		DtRows = vectors ( i ).rows();

		jj=0;
		for ( j=0;j<entries ( i ).length();j++ ) { //for RVs in entries
			int rvsize = entries ( i ).size ( j );
			for ( k=0;k<rvsize;k++ ) { { //for all scalars in given RV
					get_fname ( filename,dirname,scalarnames ( ii ) );
					if ( Len==0 ) //initialization
						fp = open ( filename, O_CREAT | O_WRONLY | O_TRUNC, 00644 );
					else
						fp = open ( filename, O_CREAT | O_WRONLY | O_APPEND, 00644 );

					write ( fp,&Dt[jj* ( DtRows ) ], ( Len ) *sizeof ( double ) );
					close ( fp );

					//next row in Dt
					jj++;
					//next scalarname
					ii++;
				}
			}
		}
	}
}

void dirfilelog::step ( ) {

	if ( ind== ( maxlen -1 ) ) {
		write_buffers ( ind+1 );
		ind = 0;
	}
	else
		ind++;

}

void dirfilelog::finalize ( ) {
	if ( ind>0 )
		write_buffers ( ind ); //assuming here that i+1 was not filled
}

}
