/*!
  \file
  \brief Loggers for storing results of experiments
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef LGR_H
#define LGR_H

#include "libBM.h"

namespace bdm{
using std::string;

/*!
* \brief Logging into matrices in data format in memory

* More?...
*/

class memlog : public logger {

protected:
	//! Maximum length of vectors stored in memory
	int maxlen;
	//! Currect record to be written
	int ind;
	//! Storage
	Array<mat> vectors;
	//!
public:
	//!Default constructor
	memlog ( int maxlen0 ) : logger(),maxlen ( maxlen0 ),ind ( 0 ),vectors ( 0 ) {}
	//! Initialize storage
	void init() {
		int i; int n =entries.length();
		vectors.set_size ( n ); 
		for ( i=0;i<n;i++ ) {vectors(i).set_size (maxlen,entries(i)._dsize() );}
		;
	}
	void step() {if ( ind<maxlen ) ind++; else it_error ( "memlog::ind is too high;" );}
	void logit ( int id, const vec &v ) {
		it_assert_debug(id<vectors.length(),"Logger was not initialized, run init().");
		vectors ( id ).set_row ( ind,v );}
	//! Save values into an itfile named after \c fname.
	void itsave(const char* fname);
};

/*!
* \brief Logging into dirfile with buffer in memory

* Dirfile is a special format used by the kst program. See documentation of kst for description.
*
* This format is used to store scalars, hence multivariate RVs must be separated.
*/

class dirfilelog : public memlog {

protected:
	//!name of the directory
	string dirname;
	//! Automatically generated 
	Array<string> scalarnames;
public:
	/*!\brief Default constructor 
	@param dirname0 name of the directory in which to store the results
	@param maxlen0 length of the memory buffers, when full the buffers will be dumped to HDD and returned to the beginning. */
	dirfilelog ( std::string dirname0, int maxlen0 ) : memlog ( maxlen0 ), dirname ( dirname0 ), scalarnames ( 0 ) {}
	//! Initialize storage
	void init();
	void step();
	void finalize();
	/*! \brief Write memory storage to disk. 
	@param Len length of buffer to be written, if 0 the file is truncated at 0.
	*/
	void write_buffers ( int Len );
};

};
#endif // LGR_H
