
/*!
  \file
  \brief UI builders for Loggers 
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef LGR_UI_H
#define LGR_UI_H

#include "loggers.h"
#include "uibuilder.h"

using namespace bdm;

/*! \brief UI for class RV (description of data vectors)

\code
rv = {
	type = "rv"; //identifier of the description
	// UNIQUE IDENTIFIER same names = same variable
	names = ["a", "b", "c", ...];   // which will be used e.g. in loggers 

	//optional arguments
	sizes = [1, 2, 3, ...];         // (optional) default = ones()
	times = [-1, -2, 0, ...];       // time shifts with respect to current time (optional) default = zeros()
}
\endcode
*/
class UIrv: public UIbuilder{
	public:
		UIrv():UIbuilder("rv"){};
		bdmroot* build(Setting &S) const{
			Array<string> A=get_as(S["names"]);
			ivec szs;
			ivec tms;
			if (S.exists("sizes")){ 
				szs=getivec(S["sizes"]);
			} else {
				szs = ones_i(A.length());
			}
			if (S.exists("times")){ 
				tms=getivec(S["times"]);
			} else {
				tms = zeros_i(A.length());
			}
			RV *tmp = new RV(A,szs,tms);
			return tmp;
		};
};
UIREGISTER(UIrv);

/*! \brief UI for dirfilelog (Kst file format) 
\code
logger = {
	type = "dirfilelog";
	dirmane = "directory_for_files"; // resulting files will be stored there
	maxlen = 100;                    // size of memory buffer, when full results are written to disk
}
\endcode
*/
class UIdirfilelog : public UIbuilder {
	public:
	UIdirfilelog():UIbuilder("dirfilelog"){};
	bdmroot* build(Setting &S) const{
		return new dirfilelog(S["dirname"],S["maxlen"]);
	};
};

UIREGISTER(UIdirfilelog);
#endif // LGR_H
