/*!
  \file
  \brief UserInfo for pmsm related objects
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#include "pmsmDS.h"
#include <uibuilder.h>

class UIpmsmIM: public UIbuilder {
	protected:
	static void tmp_set ( Setting &S, IMpmsm* IM ) {
		//set_parameters( Rs0, Ls0, dt0, Ypm0, kp0, p0, J0, Mz0 )
		IM->set_parameters ( S["Rs"], S["Ls"], 125e-6, S["Fmag"], S["kp"],  S["p"], \
				S["J"], 0.0 );
	};
	public:
	UIpmsmIM():UIbuilder("pmsmIM"){};
	bdmroot* build ( Setting &S ) const {
		IMpmsm* tmp;
		//Switch to variants
		if (S.exists("variant")){
			string var=S["variant"];
			if (var=="Stat"){tmp=new IMpmsmStat;}
			if (var=="Mf"){tmp=new IMpmsmStat;}
		} else {
			tmp= new IMpmsm;
		}
		//Set parameters (recursively)
		UIcall<IMpmsm*> ( S["params"], &tmp_set , tmp );
		return tmp;
	}	
};
UIREGISTER ( UIpmsmIM );

//! UI for pmsm observation model
class UIpmsmOM: public UIbuilder {
	public:
		UIpmsmOM():UIbuilder("pmsmOM"){};
		bdmroot* build ( Setting &S ) const {
			return new OMpmsm;
		}	
};
UIREGISTER ( UIpmsmOM );



//!UI for pmsmDS, 
class UIpmsmDS: public UIbuilder {
	static void tmp_set ( Setting &S, pmsmDS* DS ) {
		//pmsmsim_set_parameters (( Rs0,  Ls0, Fmag0, Bf0, p0, kp0,  J0, Uc0, DT0,  dt0);
		DS->set_parameters ( S["Rs"], S["Ls"], S["Fmag"], S["Bf"], S["p"], S["kp"], \
		                     S["J"], S["Uc"], S["DT"], 1.0e-6 );
	};
public:
	UIpmsmDS() :UIbuilder ( "pmsmDS" ) {};
	bdmroot* build ( Setting &S ) const {
		pmsmDS* tmp = new pmsmDS ( );
		//Calling function tmp->tmp_set
		UIcall<pmsmDS*> ( S["params"], &tmp_set , tmp );
		//
		if ( S.exists ( "profile" ) ) {
			tmp->set_profile ( S["tstep"],getvec ( S["profile"] ) );
		}
		else {
			tmp->set_profile ( 1.0, vec ( "1" ) );
		}
		return tmp;
	};

};
UIREGISTER ( UIpmsmDS );
