/*!
  \file
  \brief Bayesian Filtering for linear Gaussian models (Kalman Filter) and extensions
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EKF_TEMP_H
#define EKF_TEMP_H

#include "libKF.h"

namespace bdm{

//!Extended Kalman filter with unknown \c Q and \c R
class EKFful_unQR : public EKFfull  {
public:
	void condition ( const vec &QR0 ) {
		Q=diag(QR0(0,dimx-1));
		R=diag(QR0(dimx,dimx+dimy-1));
	};
};

//!Extended Kalman filter in Choleski form with unknown diagonal \c Q
class EKFCh_dQ : public EKFCh {
public:
	void condition ( const vec &Q0 ) {
		Q.setD ( Q0,0 );
		//from EKF
		preA.set_submatrix ( dimy+dimx,dimy,Q._Ch() );
	};
};

//!Extended Kalman filter in Choleski form with unknown \c Q
class EKFCh_chQ : public EKFCh {
	public:
		void condition ( const vec &chQ0 ) {
			Q.setCh ( chQ0);
		//from EKF
			preA.set_submatrix ( dimy+dimx,dimy,Q._Ch() );
		};
};

//!Extended Kalman filter with unknown parameters in \c IM
class EKFCh_cond : public EKFCh  {
	public:
		void condition ( const vec &val ) {
			pfxu->condition ( val );
		};
};

}
#endif //EKF_TEMP_H
