
/*!
  \file
  \brief UserInfo for Kalman filters and extensions
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#include "libPF.h"
#include <uibuilder.h>

/*!
UI for Marginalized Particle Filter estimator

The MPF is constructed from a structure with fields:
\code
estimator = {
    type = "MPF";
	BM = {type="BM"; ...}      // Conditional Bayesian model (usually Kalman filter)
	evol = {type="mpdf"; ...}  // evolution model of the "remaining" parameter

};
\endcode

*/

class UIMPF: public UIbuilder {
	public:
	UIMPF():UIbuilder("MPF"){};
	bdmroot* build ( Setting &S ) const {
		MPF *M = new MPF;
		
		M->set_parameters(); //todo
		
		return E;
	};
};
UIREGISTER ( UIEKF );


