#include "../bdm/stat/loggers_ui.h"

int mxReplaceFieldNM(mxArray *X,const char * fname,mxArray *X1)
{
	mxArray *Old;
	int i;

	if((i=mxGetFieldNumber(X,fname))==-1)
	{
		if((i=mxAddField(X,fname))==-1) return i;

	}

	Old=mxGetFieldByNumber(X,0,i);
	if(Old)mxDestroyArray(Old);
	mxSetFieldByNumber(X,0,i,X1);
	return i;

};

class mexlog : public memlog{
	public:
	//! constructor
	mexlog(int maxlen): memlog(maxlen){};
	//!
	mxArray* toCell(){
		mxArray* tmp = mxCreateStructMatrix(1,1,0,NULL);

		//copy vectors to mxStruct
		for (int i=0; i<names.length();i++){
			mat& M=vectors(i);
			mxArray* fld=mxCreateDoubleMatrix(M.rows(), M.cols(), mxREAL);
			mat2mxArray(M,fld);
			mxReplaceFieldNM(tmp, names(i).c_str(), fld);
		}
		return tmp;
	}
};

class UImexlog: public UIbuilder{
	public:
		UImexlog():UIbuilder("mexlog"){};
		bdmroot* build(Setting &S) const{
			return new mexlog(S["maxlen"]);
		};
};
UIREGISTER(UImexlog);