#include <itpp/itcomm.h>
#include <itpp/itmex.h>

#include <../../bdm/estim/arx.h>

using namespace itpp;

void mexFunction ( int n_output, mxArray *output[], int n_input, const mxArray *input[] ) {
	// Check the number of inputs and output arguments
	if ( n_output!=1 ) mexErrMsgTxt ( "Wrong number of output variables!" );
	if ( n_input!=1 ) mexErrMsgTxt ( "Wrong number of input variables!" );

	// Convert input variables to IT++ format
	mat Data = mxArray2mat ( input[0] );
	vec mn;
	// ------------------ Start of routine ---------------------------
	
	mn = sum(Data);
	
	
	// ------------------ End of routine -----------------------------

	// Create output vectors
	output[0] = mxCreateDoubleMatrix ( 1,mn.length(), mxREAL );

	// Convert the IT++ format to Matlab format for output
	vec2mxArray ( mn, output[0] );
}
