
#include "libDS.h"
using namespace bdm;

void MemDS::getdata ( vec &dt ) {
	int i;

	it_assert_debug ( dt.length() ==rowid.length(), "MemDS:getdata incompatible dt" );
	for ( i=0;i<rowid.length();i++ ) {
		dt ( i ) = Data ( rowid ( i ),time-delays ( i ) );
	}
}

void MemDS::getdata ( vec &dt,const ivec &indeces ) {
	int j,i;
	it_assert_debug ( dt.length() ==indeces.length(), "MemDS:getdata incompatible dt" );
	for ( i=0;i<indeces.length();i++ ) {
		j = indeces ( i );
		dt ( i ) = Data ( rowid ( j ),time-delays ( j ) );
	}
}

void MemDS::step() {
	if ( time<Data.cols() ) {time++;}
}

void MemDS::set_rvs ( RV &drv, RV &urv ) {
	it_assert_debug ( drv._dsize() ==rowid.length(),"MemDS::set_rvs incompatible drv" );
	it_assert_debug ( urv._dsize() ==0,"MemDS does not support urv." );

	Drv = drv;
}

MemDS::MemDS ( mat &Dat, ivec &rowid, ivec &delays ) {
	it_assert_debug ( max ( rowid ) <=Dat.rows(),"MemDS rowid is too high for given Dat." );
	it_assert_debug ( max ( delays ) <Dat.cols(),"MemDS delays are too high." );

	time = max ( delays );
	Data = Dat;
}

void ArxDS::step() {
	//shift history
	H.shift_right ( 0, dt_size );

	H.set_subvector ( dt_size-utsize, U ); // write U after Drv

	//get regressor
	rgr = rgrlnk.pushdown ( H );
	// Eval Y
	H.set_subvector ( 0, model.samplecond ( rgr ) );

}

CsvFileDS::CsvFileDS ( const string& fname, const string& orientation ) :FileDS() {
        time = 0;
                
        vec data_line;
        string line;

        ifstream fs;
	fs.open(fname.c_str());
        if(fs.is_open()) {
             while ( getline(fs, line) ) {
                 data_line.set(line);
                 Data.append_row(data_line);
             }
        }
	
	if(orientation == "BY_ROW") {
	     transpose(Data, Data);
	}

	
}

//! Auxiliary function building full history of rv0
RV fullrgr ( const RV &drv0, const RV &urv0, const RV &rrv0 ) {
	RV T ( urv0 );
	RV pom = concat ( drv0, urv0 );
	int mint = rrv0.mint();
	for ( int i=0; i>mint; i-- ) {
		pom.t ( -1 );
		T.add ( pom );
	}
	return T;
}

