#include "userinfo.h"


//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// CLASSES DEFINITION ////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////
class Transport
{
public:
	const int year;
	const string manufacturer;

	Transport( int year, string manufacturer )
		: year( year ), manufacturer( manufacturer )
	{
	}

	virtual void ToString() = 0;
};

class Car : public Transport
{
public:
	const int kilometers;

	Car( int year, string manufacturer, int kilometers )
		: Transport( year, manufacturer ), kilometers( kilometers )
	{
	}

	void ToString()
	{
		cout << "a car made in " << year << " by " << manufacturer << ", having " << kilometers << " kilometers on the clock." << endl;
	}
};

class Bike : public Transport
{
public:
	const bool electricLights;

	Bike( int age, string manufacturer, bool electricLights )
		: Transport( age, manufacturer ), electricLights( electricLights )
	{
	}

	void ToString()
	{
		cout << "a bike made in " << year << " by " << manufacturer;
		if( electricLights ) cout << " with electric lights included";						
		cout << endl;		
	}
};

//////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////// AND RELATED USER INFOS ////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////


class CarUI: public CompoundUserInfo<Car>
{
private:
	BindedElement<int> year; 
	BindedElement<int> kilometers; 
	BindedElement<string> manufacturer; 
public:
	CarUI()
		:CompoundUserInfo<Car>("car"),
#pragma warning(push)
#pragma warning(disable: 4355)
		year( this, "year", 0 ),
		kilometers( this, "kilometers", 0 ),
		manufacturer( this, "manufacturer", "unknown")
# pragma warning(pop)
	{
	}
private:

	Car* AssemblyInstance()
	{
		// assembly new instance
		return new Car( year.value, manufacturer.value, kilometers.value );
	}

	bool DisassemblyInstance(Car& instance)
	{
		year.value = instance.year;
		manufacturer.value = instance.manufacturer;
		kilometers.value = instance.kilometers;
		return true;
	}
};

template<> const TypedUserInfo<Car>& TypedUserInfo<Car>::instance = CarUI( );


class BikeUI: public CompoundUserInfo<Bike>
{
private:
	BindedElement<int> year; 
	BindedElement<bool> lights; 
	BindedElement<string> manufacturer; 
public:
	BikeUI()
		:CompoundUserInfo<Bike>("bike"),
#pragma warning(push)
#pragma warning(disable: 4355)
		year( this, "year", 0 ),
		lights( this, "electric lights", false ), 
		manufacturer( this, "manufacturer", "unknown")
#pragma warning(pop)
	{
	}
private:

	Bike* AssemblyInstance()
	{
		// assembly new instance
		return new Bike( year.value, manufacturer.value, lights.value );
	}

	bool DisassemblyInstance(Bike& instance)
	{
		year.value = instance.year;
		manufacturer.value = instance.manufacturer;
		lights.value = instance.electricLights;
		return true;
	}
};

template<> const TypedUserInfo<Bike>& TypedUserInfo<Bike>::instance = BikeUI( );


int main()
{
	Car audi( 1998, "audi", 25000);
	Car liaz( 1992, "liaz", 1555000);
	Bike author( 1996, "author", true );

	/////////////////////////////////// SAVING ///////////////////////////

	RootElement root("transport.xml");

	if( !UserInfo::Disassembly( audi, root, "pepikovo") 
		|| !UserInfo::Disassembly( liaz, root, "jardovo") 
		|| !UserInfo::Disassembly( author, root, "ondrejovo")  )
	{
		cout << "there was some error!" << endl;
		getchar();
		return 0;			
	}

	root.Save();
	cout << "all the transport means were saved correctly" << endl;				
	//getchar();

	//////////////////////////////////// LOADING ////////////////////////////////

	string whichone = "pepikovo";
	whichone = "jardovo";
//	whichone = "ondrejovo";

	root.Load();
	Transport *loaded = UserInfo::Assembly<Transport>( root,whichone);
	
	if( loaded )
		loaded->ToString();
	else
		cout << "there was some error during loading!" << endl;
		
	getchar(); 
	return 0;
}
