# - Find ACML
# Find the native ACML includes and library
# This module defines
#  ACML_INCLUDE_DIR, where to find acml.h, etc.
#  ACML_LIBRARIES, the libraries needed to use ACML.
#  ACML_FOUND, If false, do not try to use ACML.
# also defined, but not for general use are
#  ACML_LIBRARY, where to find the ACML library.


FIND_PATH(ACML_INCLUDE_DIR acml.h
 C:\\Program Files\\AMD\\acml3.6.0\\pgi32\\include  
 )

FIND_LIBRARY(ACML_LIBRARY
  NAMES libacml_dll
  PATHS C:\\Program Files\\AMD\\acml3.6.0\\pgi32\\lib
  )


IF (ACML_LIBRARY AND ACML_INCLUDE_DIR)
    SET(ACML_LIBRARIES ${ACML_LIBRARY})
    SET(ACML_FOUND "YES")
ELSE (ACML_LIBRARY AND ACML_INCLUDE_DIR)
  SET(ACML_FOUND "NO")
ENDIF (ACML_LIBRARY AND ACML_INCLUDE_DIR)


IF (ACML_FOUND)
   IF (NOT ACML_FIND_QUIETLY)
      MESSAGE(STATUS "Found ACML: ${ACML_LIBRARIES}")
   ENDIF (NOT ACML_FIND_QUIETLY)
ELSE (ACML_FOUND)
   IF (ACML_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find ACML library")
   ENDIF (ACML_FIND_REQUIRED)
ENDIF (ACML_FOUND)

# Deprecated declarations.
GET_FILENAME_COMPONENT (NATIVE_ACML_LIB_PATH ${ACML_LIBRARY} PATH)

MARK_AS_ADVANCED(
  ACML_LIBRARY
  ACML_INCLUDE_DIR
  )
