
/*!
  \file
  \brief UserInfo for Kalman filters and extensions
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#include "libKF.h"
#include <uibuilder.h>

class UIEKF: public UIbuilder {
	public:
	UIEKF():UIbuilder("EKF"){};
	bdmroot* build ( Setting &S ) const {
		diffbifn* IM; UIbuild(S["IM"],IM);
		diffbifn* OM; UIbuild(S["OM"],OM);
		
		//parameters
		EKFCh* E; E=new EKFCh;
		E->set_parameters(IM, OM, diag(getvec(S["dQ"])), diag(getvec(S["dR"])));
		
		//statistics
		int dim=IM->dimension();
		vec mu0;
		mat P0;
		if (S.exists("mu0")){mu0=getvec(S["mu0"]);}else{mu0=zeros(dim);};
		if (S.exists("P0")){mu0=getmat(S["P0"],dim);}else{P0=eye(dim);};
		E->set_statistics(mu0,P0);
		
		//connect
		RV* drv; UIbuild(S["drv"],drv);
		E->set_drv(*drv);
		RV* rv; UIbuild(S["rv"],rv);
		E->set_rv(*rv);
		
		if (S.exists("options")){E->set_options(S["options"]);};
		
		return E;
	}	
};
UIREGISTER ( UIEKF );


