#include <uibuilder.h>
#include <string>

using std::string;
using namespace std;
using namespace bdm;

class Transport : public bdmroot
{
public:
	int year;
	string manufacturer;

	Transport()
	{
		year = 1900;
		manufacturer = "unknown";
	}

	Transport( int year, string manufacturer )
		: year( year ), manufacturer( manufacturer )
	{
	}

	virtual void FromSetting( const Setting &root )
	{
		root.lookupValue( "year", year );
		root.lookupValue( "manufacturer", manufacturer );
	}

	virtual void ToSetting( Setting &root ) 
	{	
		Setting &year_setting = root.add("year", Setting::TypeInt );
		year_setting = year;

		Setting &manufacturer_setting = root.add("manufacturer", Setting::TypeString );
		manufacturer_setting = manufacturer;	
	}
};

class Car : public Transport
{
public:
	int kilometers;

	Car() : Transport()		  
	{
		kilometers = 0;
	}


	Car( int year, string manufacturer, int kilometers )
		: Transport( year, manufacturer ), kilometers( kilometers )
	{
	}

	virtual void FromSetting( const Setting &root ) 
	{	
		Transport::FromSetting( root );

		root.lookupValue( "kilometers", kilometers );
	}

	virtual void ToSetting( Setting &root ) 
	{	
		Transport::ToSetting( root );

		Setting &kilometers_setting = root.add("kilometers", Setting::TypeInt );
		kilometers_setting = kilometers;
	}

	string ToString()
	{
		stringstream stream;
		stream << "a car made in " << year << " by " << manufacturer << ", having " << kilometers << " kilometers on the clock.";
		return stream.str();
	}
};

UIREGISTER(Car);

class Bike : public Transport
{
public:
	bool electricLights;
	mat matr;

	Bike() : Transport(), matr("2,2;3,4")
	{
		electricLights = false;		
	}

	Bike( int year, string manufacturer, bool electricLights )
		: Transport( year, manufacturer ), electricLights( electricLights )
	{
	}

	~Bike()
	{
	}

	void FromSetting( const Setting &root ) 
	{	
		Transport::FromSetting( root );

		root.lookupValue( "electricLights", electricLights );

		UI::Get( matr, root, "matr" );
	}

	void ToSetting( Setting &root ) 
	{	
		Transport::ToSetting( root );

		Setting &electricLights_setting = root.add("electricLights", Setting::TypeBoolean );
		electricLights_setting = electricLights;

		UI::Save( matr, root, "matr" );
	}

	string ToString()
	{
		stringstream stream;
		stream << "a bike made in " << year << " by " << manufacturer;
		if( electricLights ) stream << " with electric lights included";						
		return stream.str();
	}
};

UIREGISTER(Bike);

int main()
{	
	/////////////////////////////////// SAVING //////////////////////////
	/*
	Car audi( 1998, "audi", 25000);
	Car liaz( 1992, "liaz", 1555000);
	Bike author( 1996, "author", true );

	UIFile root("UIbuilder_test.cfg");	
	UI::Save( audi, root, "pepikovo");
	UI::Save( liaz, root, "jardovo"); 
	UI::Save( author, root, "ondrejovo");
	root.Save();

	cout << "all the transport means were saved correctly" << endl;				
	getchar();
	*/
	
	//////////////////////////////////// LOADING ////////////////////////////////
	UIFile root("UIbuilder_test.cfg");	
	root.Load();
	Transport *pepikovo = UI::Build<Transport>( root, "pepikovo");	
	cout << "pepikovo: " << pepikovo->ToString() << endl;		
	Transport *jardovo = UI::Build<Transport>( root, "jardovo");	
	cout << "jardovo: " << jardovo->ToString() << endl;		
	Transport *ondrejovo = UI::Build<Transport>( root, "ondrejovo");	
	cout << "ondrejovo: " << ondrejovo->ToString() << endl;		
	Transport *elisky = UI::Build<Transport>( root, "elisky");	
	cout << "elisky: " << elisky->ToString() << endl;		
	Transport *kati = UI::Build<Transport>( root, "kati");	
	cout << "kati: " << kati->ToString() << endl;		
	getchar(); 
	return 0;
}
