//
// C++ Implementation: itpp_ext
//
// Description:
//
//
// Author: smidl <smidl@utia.cas.cz>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "uibuilder.h"

namespace bdm {

UI::StringToUIMap::MappedString2UI& UI::StringToUIMap::privateMap()
{
	static MappedString2UI var;
	return var;
}

void UI::StringToUIMap::Add( const string &className, pUI pInstance )
{
	privateMap().insert( make_pair( className, pInstance ) );
}

UI::pUI UI::StringToUIMap::Retrieve( const string &className )
{
	MappedString2UI::const_iterator iter = privateMap().find( className );
	if( iter == privateMap().end()) return NULL;
	else return iter->second;
}	

//////////////////////////////////////////////////////////////////////


UIFile::UIFile ( const string &file_name ) : fileName( file_name )
{
	Config::setAutoConvert( true );
}

//! loads root element from a file
void UIFile::Load() 
{
	try
	{
		Config::readFile( fileName.c_str()  );
	}
	catch ( FileIOException f ) 
	{
		it_error ( "UI: file " + fileName + " not found." );
	}
	catch ( ParseException& P ) 
	{
		stringstream msg;
		msg << "UI: parsing error """ << P.getError() << """ in file " << fileName << " on line " <<  P.getLine() << ".";
		it_error ( msg.str() );
	}	
}


//! Save UserInfo to the file (typically with an XML extension)
void UIFile::Save()
{
	try
	{
		Config::writeFile ( fileName.c_str()  );
	}
	catch ( FileIOException f ) 
	{
		it_error( "UI: file " + fileName + " is inacessible." );
	}		
}	

UIFile::operator Setting&()
{
	return getRoot();
}

}
/*
#include "uibuilder.h"

namespace bdm {

//! global map of UIbulder names to instances of UIbuilders. Created by UIREGISTER macro
UIbuilder::UImap UIbuilder::__uimap__;

bdmroot* UIexternal::build ( Setting &S ) const {
	Config C;
	bdmroot* tmp;
	try {
		C.readFile ( ( const char* ) S["filename"] );
	}
	catch ( ... ) {
		it_error ( "File " + string ( ( const char* ) S["filename"] ) + " not found or broken" );
	}
	try {
		Setting& remS=C.lookup ( ( const char* ) S["path"] );
		UIbuilder::build( remS,tmp );
	}
	catch ( ... ) {
		it_error ( "External field " + string ( S.getPath() ) + " not valid" );
	}
	return tmp;
};
UIREGISTER ( UIexternal );

bdmroot* UIinternal::build ( Setting &S ) const {
	bdmroot* tmp;
	try {
		Setting* Stmp = &S;
		do {Stmp=& ( Stmp->getParent() );}
		while ( !Stmp->isRoot() );
		Setting& intS=Stmp->lookup ( ( const char* ) S["path"] );
		UIbuilder::build( intS,tmp );
	}
	catch ( ... ) {
		it_error ( "Internal field " + string ( S.getPath() ) + " not valid" );
	}
	return tmp;
};
UIREGISTER ( UIinternal );

void UI_DBG ( Setting &S, const string &spc ) {
	const char *Name=S.getName();
	if ( Name!=NULL ) {cout << spc << std::string ( Name );};
	Setting::Type T=S.getType();
	switch ( T ) {
		case Setting::TypeArray:
			cout << endl;
			for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );};
			break;
		case Setting::TypeList:
			cout << endl;
			for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );};
			break;
		case Setting::TypeGroup:
			cout << endl;
			for ( int i=0;i<S.getLength();i++ ) {UI_DBG ( S[i], spc+" " );}
			break;
		case Setting::TypeInt:
			cout << " = ";
			cout << int ( S ) <<endl;
			break;
		case Setting::TypeFloat:
			cout << " = ";
			cout << double ( S ) <<endl;
			break;
		case Setting::TypeString:
			cout << " = ";
			cout << ( const char* ) ( S ) <<endl;
			break;
		case Setting::TypeBoolean:
			cout << " = ";
			cout << bool ( S ) <<endl;
			break;
		default: {cout << "?";};
	}
}

}
//UIexternal* UIexternal_instance =new UIexternal();
*/