#include <user_info.h>
#include <string>

using std::string;
using namespace std;
using namespace bdm;

class Transport : public bdmroot
{
public:
	int year;
	string manufacturer;

	Transport()
	{
		year = 1900;
		manufacturer = "unknown";
	}

	Transport( int year, string manufacturer )
		: year( year ), manufacturer( manufacturer )
	{
	}

	virtual void from_setting( const Setting &root )
	{
		root.lookupValue( "year", year );
		root.lookupValue( "manufacturer", manufacturer );
	}

	virtual void to_setting( Setting &root ) 
	{	
		Setting &year_setting = root.add("year", Setting::TypeInt );
		year_setting = year;

		Setting &manufacturer_setting = root.add("manufacturer", Setting::TypeString );
		manufacturer_setting = manufacturer;	
	}
};

class Car : public Transport
{
public:
	int kilometers;

	Car() : Transport()		  
	{
		kilometers = 0;
	}


	Car( int year, string manufacturer, int kilometers )
		: Transport( year, manufacturer ), kilometers( kilometers )
	{
	}

	virtual void from_setting( const Setting &root ) 
	{	
		Transport::from_setting( root );

		root.lookupValue( "kilometers", kilometers );
	}

	virtual void to_setting( Setting &root ) 
	{	
		Transport::to_setting( root );

		Setting &kilometers_setting = root.add("kilometers", Setting::TypeInt );
		kilometers_setting = kilometers;
	}

	string ToString()
	{
		stringstream stream;
		stream << "a car made in " << year << " by " << manufacturer << ", having " << kilometers << " kilometers on the clock.";
		return stream.str();
	}
};

UIREGISTER(Car);

class Bike : public Transport
{
public:
	bool electricLights;
	mat matr;

	Bike() : Transport(), matr("2,2;3,4")
	{
		electricLights = false;		
	}

	Bike( int year, string manufacturer, bool electricLights )
		: Transport( year, manufacturer ), electricLights( electricLights )
	{
	}

	~Bike()
	{
	}

	void from_setting( const Setting &root ) 
	{	
		Transport::from_setting( root );

		root.lookupValue( "electricLights", electricLights );

		UI::get( matr, root, "matr" );
	}

	void to_setting( Setting &root ) 
	{	
		Transport::to_setting( root );

		Setting &electricLights_setting = root.add("electricLights", Setting::TypeBoolean );
		electricLights_setting = electricLights;

		UI::save( matr, root, "matr" );
	}

	string ToString()
	{
		stringstream stream;
		stream << "a bike made in " << year << " by " << manufacturer;
		if( electricLights ) stream << " with electric lights included";						
		return stream.str();
	}
};

UIREGISTER(Bike);

int main()
{	
	/////////////////////////////////// SAVING //////////////////////////
	/*
	Car audi( 1998, "audi", 25000);
	Car liaz( 1992, "liaz", 1555000);
	Bike author( 1996, "author", true );

	UI_File root("testUI.cfg");	
	UI::save( audi, root, "pepikovo");
	UI::save( liaz, root, "jardovo"); 
	UI::save( author, root, "ondrejovo");
	root.save();

	cout << "all the transport means were saved correctly" << endl;				
	getchar();
	*/
	
	//////////////////////////////////// LOADING ////////////////////////////////
	UI_File root("testUI.cfg");	
	root.load();
	Transport *pepikovo = UI::build<Transport>( root, "pepikovo");	
	cout << "pepikovo: " << pepikovo->ToString() << endl;		
	Transport *jardovo = UI::build<Transport>( root, "jardovo");	
	cout << "jardovo: " << jardovo->ToString() << endl;		
	Transport *ondrejovo = UI::build<Transport>( root, "ondrejovo");	
	cout << "ondrejovo: " << ondrejovo->ToString() << endl;		
	Transport *elisky = UI::build<Transport>( root, "elisky");	
	cout << "elisky: " << elisky->ToString() << endl;		
	Transport *kati = UI::build<Transport>( root, "kati");	
	cout << "kati: " << kati->ToString() << endl;		
	getchar(); 
	return 0;
}
