#include <itpp/itmex.h>
#include <estim/arx.h>

using namespace bdm;

void mexFunction(int n_output, mxArray *output[], int n_input, const mxArray *input[])
{
    // Check the number of inputs and output arguments
	if(n_output!=1) mexErrMsgTxt("Wrong number of output variables!");
	if(n_input!=2) mexErrMsgTxt("Usage: arx1d(ysize, Data)!");

    // Convert input variables to IT++ format
	int ysize = mxArray2int(input[0]);
	mat Data = mxArray2mat(input[1]);

    // ------------------ Start of routine ---------------------------
	ARX Ar;
	Ar.set_statistics(ysize, 1e-5*eye(Data.rows()) );
	Ar.bayesB(Data);
	// ------------------ End of routine -----------------------------

    // Create output vectors
	output[0] = mxCreateDoubleMatrix(1,Data.rows(), mxREAL);

    // Convert the IT++ format to Matlab format for output
	vec2mxArray(Ar.posterior().mean(), output[0]);
}
