
#include <string>
#include "user_info.h"

using std::string;
using namespace std;
using namespace bdm;

class Passenger : public bdmroot
{
public:

  Passenger() {
  }
};

class Human : public Passenger
{
public:
  string name;

  Human() {
    name = "none";
  }

  virtual void from_setting(const Setting &root) {
    root.lookupValue("name", name);
  }

  virtual void to_setting(Setting &root) const {
    Setting &name_setting = root.add("name", Setting::TypeString);
    name_setting = name;
  }

  string to_string() {
    return name;
  }
};

UIREGISTER(Human);

class Robot : public Passenger
{
public:
  int number;
  Array<string> software;

  Robot() : software() {
    number = -1;
  }

  virtual void from_setting(const Setting &root) {
    root.lookupValue("number", number);
	if( root.exists( "software" ) )
		UI::get(software, root, "software");
  }

  virtual void to_setting(Setting &root) const {
    Setting &number_setting = root.add("number", Setting::TypeInt);
    number_setting = number;

    UI::save(software, root, "software");
  }

  string to_string() {
    stringstream stream;
    stream << number;
    for (int i = 0; i < software.length(); i++)
      stream << "_" + software(i);
    return stream.str();
  }
};

UIREGISTER(Robot);

class Transport : public bdmroot
{
public:
  int year;
  string manufacturer;

  Transport() {
    year = 1900;
    manufacturer = "unknown";
  }

  Transport(int year, string manufacturer)
      : year(year), manufacturer(manufacturer) {
  }

  virtual void from_setting(const Setting &root) {
    root.lookupValue("year", year);
    root.lookupValue("manufacturer", manufacturer);
  }

  virtual void to_setting(Setting &root) const {
    Setting &year_setting = root.add("year", Setting::TypeInt);
    year_setting = year;

    Setting &manufacturer_setting = root.add("manufacturer", Setting::TypeString);
    manufacturer_setting = manufacturer;
  }
};

class Car : public Transport
{
public:
  int kilometers;
  Array<Passenger*> passengers;

  Car() : Transport() {
    kilometers = 0;
  }


  Car(int year, string manufacturer, int kilometers)
      : Transport(year, manufacturer), kilometers(kilometers) {
  }

  virtual void from_setting(const Setting &root) {
    Transport::from_setting(root);

    root.lookupValue("kilometers", kilometers);

	if( root.exists( "passengers" ) )
	    UI::get(passengers, root, "passengers");
  }

  virtual void to_setting(Setting &root) const {
    Transport::to_setting(root);

    Setting &kilometers_setting = root.add("kilometers", Setting::TypeInt);
    kilometers_setting = kilometers;

    UI::save(passengers, root, "passengers");
  }

  string to_string() {
    stringstream stream;
    stream << "A car made in " << year << " by " << manufacturer << ", having " << kilometers << " kilometers on the clock.";
    if (passengers.length()) {
      stream << "The names of passengers are as follows: ";
      for (int i = 0; i < passengers.length(); i++)
        stream << passengers(i)->to_string() << " ";
    }
    return stream.str();
  }
};

UIREGISTER(Car);

class Bike : public Transport
{
public:
  bool electricLights;
  mat matr;

  Bike() : Transport(), matr("2,2;3,4") {
    electricLights = false;
  }

  Bike(int year, string manufacturer, bool electricLights)
      : Transport(year, manufacturer), electricLights(electricLights) {
  }

  ~Bike() {
  }

  void from_setting(const Setting &root) {
    Transport::from_setting(root);

    root.lookupValue("electricLights", electricLights);

	UI::get(matr, root, "matr");
  }

  void to_setting(Setting &root) const {
    Transport::to_setting(root);

    Setting &electricLights_setting = root.add("electricLights", Setting::TypeBoolean);
    electricLights_setting = electricLights;

    UI::save(matr, root, "matr");
  }

  string to_string() {
    stringstream stream;
    stream << "a bike made in " << year << " by " << manufacturer;
    if (electricLights) stream << " with electric lights included";
    return stream.str();
  }
};

UIREGISTER(Bike);

int main()
{
  //////////////////////////////////// LOADING ////////////////////////////////
  UI_File in("testUI_in.cfg");
  Transport *pepikovo = UI::build<Transport>(in, "pepikovo");
  cout << "pepikovo: " << pepikovo->to_string() << endl;
  Transport *jardovo = UI::build<Transport>(in, "jardovo");
  cout << "jardovo: " << jardovo->to_string() << endl;
  Transport *ondrejovo = UI::build<Transport>(in, "ondrejovo");
  cout << "ondrejovo: " << ondrejovo->to_string() << endl;
  Transport *elisky = UI::build<Transport>(in, "elisky");
  cout << "elisky: " << elisky->to_string() << endl;
  Transport *kati = UI::build<Transport>(in, "kati");
  cout << "kati: " << kati->to_string() << endl;
  getchar();

  /////////////////////////////////// SAVING //////////////////////////

  Car audi(1968, "zyl", 200);
  Car liaz(1989, "skoda", 1000);
  Bike author(2001, "noname", false);
  UI_File out;

  UI::save(&audi, out, "marty");
  UI::save(&liaz, out, "bohousovo");
  UI::save(&author, out, "karlovo");
  UI::save(pepikovo, out, "pepikovo");
  out.save("testUI_out.cfg");

  cout << "all the transport means were saved correctly" << endl;
  getchar();
  return 0;
}
