#include "../bdm/stat/libDS_ui.h"

/*! \brief Create memory data source from mxArray

\code
system={
	type="mexDS";
	varname="";            // name of workspace variable
	rids=[1 1 1];          // numbers of data rows
	tds =[0 1 2];          // time delays
	};
\endcode

MemDS with the above fields will be created;

\todo Very memory inefficient implementation. The data file is copied 2 times! 
For better implementatin we would need MemDS with pointer to the raw data. Then it could operate directly inside mxArray.

*/
class UImexDS: public UIbuilder{
	public:
		UImexDS():UIbuilder("mexDS"){};
		bdmroot* build(Setting &S) const{
			mat Data;
			ivec rids;
			ivec tds;
			try{
				Data = mxArray2mat(mexGetVariable("base",S["varname"]));
				rids=getivec(S["rids"]);
				tds = getivec(S["tds"]);
			}
			catch UICATCH ;
			
			MemDS* M=new MemDS(Data,rids,tds);
			RV* r; UIbuild(S["rv"],r);
			RV ru=RV();
			M->set_rvs(*r,ru);
			return M;
		};
};
UIREGISTER(UImexDS);
