#include <itpp/itmex.h>
#include <estim/arx.h>

using namespace bdm;

class mexEpdf: public epdf{
	protected:
		string name;
		mxArray *data;
	public:
		mexEpdf() {};
		void from_setting(const Setting &S)  {
			name = (const char *) S["name"];
			string fname = name+"_new";
			mexCallMATLAB(1, &data, 0, 0, fname.c_str());
			//TODO (future...):
			//mxArray * init_data = setting2mxarray S["init_data"];
			//mexCallMATLAB(1, &data, 1, &init_data, name+"_from_setting");
			//delete init_data;
		} 
		vec mean() const {
			mxArray *tmp;
			string fname = name+"_mean";
			mexCallMATLAB(1, &tmp, 1, (mxArray **) &data, fname.c_str());
			return mxArray2vec(tmp);
		} 
};

class mexBM: public BM{
	protected :
		string name;
		mexEpdf est;
		mxArray *data;
	public:
		mexBM() {}

		void from_setting(const Setting &S)  {
			name = (const char *) S["name"];
			string fname = name+"_new";
			mexCallMATLAB(1, &data, 0, 0, (name+"_new").c_str());
			//the following works as long as the posterior is the
			//only member object there could be a structure of 
			//member objects in the setting and a for cycle over
			//all of them right here in the code
			Setting &posterior = S["posterior"]; 
			est.from_setting(posterior);
		}
		void bayes(const vec &dt)  {
		//void bayes()  {
			string fname = name+"_bayes";
			mexCallMATLAB(1, &data, 1, &data, fname.c_str());
		} 
		const mexEpdf& posterior() const  {
			return est;
		} //tohle by melo zustat!!
		const mexEpdf* _e() const  {
			return &est;
		} //tohle by melo zustat!!
};

void mexFunction(int n_output, mxArray *output[], int n_input, const mxArray *input[])
{
    // Check the number of inputs and output arguments
	if(n_input!=1) mexErrMsgTxt("Wrong number of input variables - expected parameter 'filename'!");

 	// ------------------ Start of routine ---------------------------

	//mexBM mB(mxArray2string(input[0])); // naplni
	//mB.bayes(vec_1(1.3));
	string filename = mxArray2string(input[0]);
	Config config;
	config.readFile(filename.c_str());
	mexBM mb;
	mb.from_setting(config.getRoot());
	vec a = "1.0 2.0 3.0";
	mb.bayes(a);
	

	// ------------------ End of routine -----------------------------

    // Create output vectors
	output[0] = mxCreateDoubleMatrix(1,1, mxREAL);

    // Convert the IT++ format to Matlab format for output
	//vec2mxArray(mB.posterior().mean(), output[0]);
}
