
#include <stat/libEF.h>
#include <estim/merger.h>

using namespace bdm;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {

	RNG_randomize();

	RV x ( "{x }","1" );

	RV z ( x );

	enorm<fsqmat> f1; f1.set_rv ( x );
	enorm<fsqmat> f2; f2.set_rv ( x );

	f1.set_parameters ( "-5",mat ( "2" ) );
	f2.set_parameters ( "5",mat ( "10" ) );

	Array<mpdf* > A ( 2 );
	mepdf A1 ( &f1 );
	mepdf A2 ( &f2 );
	A ( 0 ) =&A1;
	A ( 1 ) =&A2;

	int Npoints=100;
	mat x_grid ( 1,Npoints );
	x_grid.set_row ( 0,linspace ( -10.0, 10.0 ) );

	vec l_f1=f1.evallog_m ( x_grid );
	vec l_f2=f2.evallog_m ( x_grid );
	mat lW ( 2,Npoints );
	lW.set_row ( 0, l_f1 );
	lW.set_row ( 1, l_f2 );

	merger_base M ( A );
	enorm<fsqmat> g0; g0.set_rv ( x );
	g0.set_parameters ( vec ( "0.0" ),mat ( "100.0" ) );

	M.set_method (  LOGNORMAL, 1.2 );
	M.set_support(g0,200);
	M.merge ();

	vec m2 = M.merge_points ( lW );
//	vec mm2 = M.evallog_m ( x_grid );

	it_file it ( "merger_test.it" );
	it << Name ( "x_grid" ) << x_grid;
	it << Name ( "lf1" ) << l_f1;
	it << Name ( "lf2" ) << l_f2;
	it << Name ( "m2" ) << m2;
//	it << Name ( "mm2" ) << mm2;
}
