#include <itpp/itmex.h>
#include <estim/merger.h>
#include "config2mxstruct.h"
#include "mexlog.h"
#include "mexparse.h"

using namespace bdm;

void mexFunction(int n_output, mxArray *output[], int n_input, const mxArray *input[])
{
    // Check the number of inputs and output arguments
	if(n_input!=1) mexErrMsgTxt("Configuration structure expected in the form:\n"  
		"S.sources = { };                          % cell of pdfs (epdfs or mpdfs) to be merged,\n"
		"S.merger= struct('class','merger_*');     % object to be used for merging,\n\n"
		"see documentation of classes epdf, mpdf, merger_base and their offsprings in BDM.");

	// LOAD CONFIG
	UImxArray F (input[0]);

	Array<mpdf*> Sources;

	Setting& _Sources=F.lookup("sources");
	int Slen=_Sources.getLength();
	Sources.set_size(Slen);
	for (int i=0; i<Slen; i++){
		mpdf* mtmp = UI::build<mpdf>(_Sources,i);
		if (mtmp) { 
			Sources(i)=mtmp;
		} else{ // source is not mpdf
			epdf* etmp = UI::build<epdf>(_Sources,i);
			if (etmp){
				Sources(i) = new mepdf(etmp, true);
			}
		}

	}
	
	merger_base* Merger=UI::build<merger_base>(F.getRoot(),"merger");

// COMPUTE RESULTS

	Merger->merge();
	
	if (n_output>0){
		mxArray* tmp = mxCreateStructMatrix(1,1,0,NULL);
		//support
		Array<vec> &samples=Merger->_Smp()._samples();
		if (samples.size()>0){
			mxArray* fld=mxCreateDoubleMatrix(samples(0).length(), samples.size(), mxREAL);
		Arrayvec2mxArray(samples,fld);
		mxReplaceFieldNM(tmp, "support", fld);
		}

		//weights
		vec &w = Merger->_Smp()._w();
		mxArray* fldw=mxCreateDoubleMatrix(1, w.length(), mxREAL);
		vec2mxArray(w,fldw);
		mxReplaceFieldNM(tmp, "weights", fldw);
		
		output[0] = tmp;
	}
}
