
#include "stat/exp_family.h"

using namespace bdm;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;


int main() {

	vec x = "-10:0.1:10";
	vec y = "-10:0.1:10";

	RV rv ( "{x }","2" );
	vec mu0 = "0.0 0.0";
	mat V0 ( "5 -0.05; -0.05 5.20" );
	fsqmat R = fsqmat ( V0 );

	cout << "====== ENorm ====== " <<endl;
	enorm<fsqmat> eN;eN.set_rv ( rv );
	eN.set_parameters ( mu0,R );
	vec pdf = zeros ( x.length() );

	vec pom ( 2 );
	double suma=0.0;

	for ( int i=0;i<x.length();i++ ) {
		for ( int j=0;j<y.length();j++ ) {
			pom ( 0 ) = x ( i );
			pom ( 1 ) = y ( j );
			suma+= exp(eN.evallog ( pom ));
		}
	}

	cout << suma <<endl;

	//Exit program:
	return 0;

}

