% Random Variables
a=struct('class','RV','names',{{'a'}});
b=struct('class','RV','names',{{'b'}});
ab=struct('class','RV','names',{{'a','b'}});

% Sources
f1.class= 'enorm<ldmat>';
f1.mu   = 3;
f1.R    = 1;
f1.rv   = b;

% merger 
merger.class='merger_mix';
merger.method='lognormal';
merger.beta=2;
merger.ncoms=20;
merger.stop_niter=5;
merger.effss_coef=1;
%merger.dbg_file='merger_mix_dbg';


% 2D sources
f3 = struct('class','enorm<ldmat>',...
    'mu',[1,2],...
    'R',  [2 0; 0 1.5],...
    'rv', ab);
f4 = struct('class','egiw',...
    'V',4*[5 2; 2 1],...
    'nu',  4,...
    'dimx',  1,...
    'rv', ab);
% 2D support
support2.grid={[-5,5],[0.001,5]};
support2.nbins=[20,20];

% 2D
vy2=merger_mx({f3,f1}, support2, merger)
X=zeros(support2.nbins(1));
Y=zeros(support2.nbins(1));
Z=zeros(support2.nbins(1));

figure(2);
subplot(1,3,1);
hold off
plot(vy2.support(1,:),vy2.support(2,:),'.','MarkerSize',4)
hold on
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.weights)
subplot(1,3,2);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source1)
subplot(1,3,3);
contour_2(vy2.support(1,:),vy2.support(2,:),vy2.source2)