
#include <math/square_mat.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;

int main() {
	// Kalman filter
	mat A0 = randu(3,3);
	mat A = A0*A0.T();
	
	//Test constructor
	ldmat LD(A);
   cout << "Testing constructors:" << endl
       << "A = " << A << endl
       << "LD.to_mat() = " << LD.to_mat() << endl << endl;
       
   //Test inversion
	ldmat iLD(3);
	LD.inv(iLD);
   cout << "inv(A) = " << inv(A) <<endl
   	<< "inv(LD).to_mat() = " << iLD.to_mat() <<endl <<endl;
   	
   //Test logdet
   cout << "logdet(A) = " << log(det(A)) << endl
			<< "logdet(LD) = " << LD.logdet() << endl <<endl;
				
   //Test add
   ldmat LD2(LD);
   LD2.add(LD);
   cout << "A+A = " << A+A << endl
			<<	"LD2.add(LD) = " << LD2.to_mat() << endl <<endl;
				
	vec v=randu(3);
   //Test qform
   cout << "vAv' = " << v*(A*v) << endl
			<<	"qform(LD,v) = " << LD.qform(v) << endl <<endl;
	
   //Test invqform
   cout << "v inv(A)v' = " << v*(inv(A)*v) << endl
			<<	"invqform(LD,v) = " << LD.invqform(v) << endl <<endl;
				
   //Test opupdate
   LD2=LD;
   LD2.opupdt(v,1.0);
   cout << "A+vv' = " << A+outer_product(v,v) << endl
			<<	"opupdt(LD,v) = " << LD2.to_mat() << endl <<endl;
				
}
