/*!
  \file
  \brief Simulation of disturbances in PMSM model, PWM and integration disturbances are distinguished
  \author Vaclav Smidl.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#include "pmsm_ui.h"
#include "sim_profiles.h"
#include <stat/loggers_ui.h>

using namespace bdm;
int main() {
	UIFile F("sim.txt");

	logger* L; 
	UIbuild(F.lookup("logger"),L);
	pmsmDS * DS;
	UIbuild(F.lookup("system"),DS);
	int Ndat;
	F.lookupValue("ndat",Ndat);
	// SET SIMULATOR

	DS->log_add(*L);
	
//	int L_KO=L->add(RV("{ua ub ia ib ta tb }"),"");
	L->init();
	
	pmsmsim_set_parameters ( 0.28,0.003465,0.1989,0.0,4,1.5,0.04, 200., 3e-6, 1e-6 );

	double Ww=0.0;
	vec vecW = "1 2 4 8 4 2 0 -4 -9 -16 -4 0 0 0";
	for ( int tK=1;tK<9000;tK++ ) {
		if (0)
		{
		for(int tt =0; tt<125; tt++){
			sim_profile_steps1 ( Ww , false);
			//sim_profile_vec01t ( Ww,vecW );
		pmsmsim_step ( Ww );
		}
		}
		else {DS->step();}
// 		DS->step();
 		DS->logit(*L);
//		L->logit(L_KO,vec(KalmanObs,6));		
		L->step();
	}
	
	L->finalize(); 
	
	delete L;
	//delete DS;
	return 0;
}

