/*!
  \file
  \brief Utility functions for BDM unit tests.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef TEST_UTIL_H
#define TEST_UTIL_H

#include <string>

namespace bdm {

/*! \brief Non-general but simple file load.

  Handles only files smaller than 8KB which do not contain '\0'
  characters, but for testing that should be enough.
*/
std::string load_test_file(const char *fname);

/*! \brief Recursively removes directories and files.

  path is the name (absolute or relative) of the file or directory to
  be removed (must not be empty). Returns true on success, false when
  path couldn't be removed because it didn't exist, throws an
  exception otherwise.
*/
bool remove_all(const char *path);

}

#endif
