#include <itpp/itbase.h>
#include <stat/libEF.h>

using namespace itpp;

//These lines are needed for use of cout and endl
using std::cout;
using std::endl;


int main() {

	vec x = "-10:0.1:10";
	vec y = "-10:0.1:10";

	RV rv ( "1","{x }","2","0" );
	vec mu0 = "0.0 0.0";
	mat V0 ( "5 -0.05; -0.05 5.20" );
	fsqmat R = fsqmat ( V0 );

	cout << "====== ENorm ====== " <<endl;
	enorm<fsqmat> eN ( rv );
	eN.set_parameters ( mu0,R );
	vec pdf = zeros ( x.length() );

	vec pom ( 2 );
	double suma=0.0;

	for ( int i=0;i<x.length();i++ ) {
		for ( int j=0;j<y.length();j++ ) {
			pom ( 0 ) = x ( i );
			pom ( 1 ) = y ( j );
			suma+= eN.eval ( pom );
		}
	}

	cout << suma <<endl;

	//Exit program:
	return 0;

}

