/*!
  \file
  \brief Support for testing descendants of epdf.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EPDF_HARNESS_H
#define EPDF_HARNESS_H

#define BDMLIB // not an ideal way to prevent double registration of UI factories...

#include "bdmroot.h"
#include "itpp_ext.h"
#include "shared_ptr.h"
#include "base/bdmbase.h"
#include "base/user_info.h"

namespace bdm
{

class epdf_harness : public root
{
private:
    shared_ptr<epdf> hepdf;
    vec mean;
    vec variance;
    double lognc;
    mat support;
    int nsamples;
    double integral;

public:
    epdf_harness():lognc(0), nsamples(100), integral(0) { }

    void test();

    void from_setting(const Setting &set);
};

}

#endif
