# This Module Sets CMake variables for BDM
# Variable BDM_SOURCE_DIR must be set
#
# Other respected variables are
# ITPP_DIR, ACML_DIR, MATLAB_ROOT
#

IF(NOT BDM_SOURCE_DIR)
      MESSAGE(FATAL_ERROR "BDM_SOURCE_DIR is not set!")
ENDIF(NOT BDM_SOURCE_DIR)

######################
#Platform specific
IF(WIN32)
# IF YOU WANT TO USE YOUR OWN INSTALLATION OF THE NEXT EXTERNAL LIBRARIES,
# THEN IT IS NECESSARY TO CREATE TEXT FILE "\system\WIN32\LOCAL_PATHS.TXT" WITH 
# COPIES OF THE TWO FOLLOWING LINES AND THEN CORECT ALL THE INVOLVED PATHS
	IF(NOT ITPP_DIR)
		SET(ITPP_DIR "${BDM_SOURCE_DIR}\\system\\win32\\itpp-4.0.6")
	ENDIF(NOT ITPP_DIR)
	IF(NOT ACML_DIR)
		SET(ACML_DIR "${BDM_SOURCE_DIR}\\system\\win32\\acml3.6.0")
	ENDIF(NOT ACML_DIR)
	
	INCLUDE(\\system\\win32\\local_paths.txt OPTIONAL)	
	ADD_DEFINITIONS(-DHAVE_ACML)
	ADD_DEFINITIONS(/wd4290)
	ADD_DEFINITIONS(-D_CRT_SECURE_NO_WARNINGS)
ENDIF(WIN32)
IF(APPLE)
	IF(NOT ITPP_DIR)
		SET(ITPP_DIR "${BDM_SOURCE_DIR}/macosx/itpp-4.0.6")
	ENDIF(NOT ITPP_DIR)
	FIND_LIBRARY(FRAMEWORK_VECLIB vecLib)
	ADD_DEFINITIONS(-DHAVE_XLOCALE_H)
ENDIF(APPLE)
IF(UNIX)
	# Generally this directory should not exist!
	# Use this location is you compile itpp from sources
	IF(NOT ITPP_DIR)
		SET(ITPP_DIR "${BDM_SOURCE_DIR}/system/linux/")
	ENDIF(NOT ITPP_DIR)
	#This is for UNIX makefile which does only one release at a time.
ENDIF(UNIX)

# Local ettings should be written to file called CMakeLists.local
# Use this option for machine-specific options, such as prallel architectures
INCLUDE(CMakeLists.local OPTIONAL)	

FIND_PACKAGE(ITPP REQUIRED)
FIND_PACKAGE(ACML COMPONENTS)
FIND_PACKAGE(Matlab COMPONENTS)
FIND_PROGRAM(MEX_COMPILER mex)

IF(ITPP_FOUND)
	INCLUDE_DIRECTORIES(${ITPP_INCLUDE_DIR})
	LINK_DIRECTORIES(${NATIVE_ITPP_LIB_PATH})
ENDIF(ITPP_FOUND)

IF(ACML_FOUND)
	INCLUDE_DIRECTORIES(${ACML_INCLUDE_DIR})
	LINK_DIRECTORIES(${NATIVE_ACML_LIB_PATH})
ENDIF(ACML_FOUND)

IF(UNIX)
	SET(CMAKE_BUILD_TYPE Debug)
	IF(MATLAB_FOUND)
		SET(CMAKE_CXX_FLAGS "-Wall -pipe  -Wno-unknown-pragmas -fPIC")
		SET(CMAKE_C_FLAGS "-Wall -pipe  -Wno-unknown-pragmas -fPIC")
	ELSE(MATLAB_FOUND)
		SET(CMAKE_CXX_FLAGS "-Wall -Wno-unknown-pragmas ")
		SET(CMAKE_C_FLAGS "-Wall -Wno-unknown-pragmas ")
	ENDIF(MATLAB_FOUND)
	
	SET(CMAKE_CXX_FLAGS_RELEASE " -DNDEBUG -O2")
	SET(CMAKE_CXX_FLAGS_DEBUG "-g -O0")
ENDIF(UNIX)

##
## PREPARE MACROS for building executables
##

MACRO(EXEC FN)
	add_executable (${FN} ${FN}.cpp)
	IF(WIN32)
		target_link_libraries (${FN} debug itpp_debug)
		target_link_libraries (${FN} optimized itpp)
		target_link_libraries (${FN} libacml_dll)
 	ELSE(WIN32)
 		IF(APPLE)
 			target_link_libraries (${FN} ${FRAMEWORK_VECLIB})
 		ENDIF(APPLE)
		target_link_libraries (${FN} itpp)	
#		target_link_libraries (${FN} debug itpp_debug)
#		target_link_libraries (${FN} optimized itpp)
 	ENDIF(WIN32)
	target_link_libraries (${FN} bdm)
	target_link_libraries (${FN} ${ARGN}) ## Additional libraries can be added to a macro
ENDMACRO(EXEC)
	
MACRO(MEX FN)
	IF(MEX_COMPILER)
	INCLUDE_DIRECTORIES(${MATLAB_INCLUDE_DIR} "${BDM_SOURCE_DIR}/bdm")
	LINK_DIRECTORIES("${BDM_SOURCE_DIR}/bdm")
	IF(WIN32)
		ADD_DEFINITIONS(/EXPORT:_mexFunction)
	ENDIF(WIN32)
	ADD_LIBRARY("${FN}.${MATLAB_MEX_SUFFIX}" MODULE ${FN}.cpp)
	set_target_properties("${FN}.${MATLAB_MEX_SUFFIX}" PROPERTIES
		PREFIX ""
		SUFFIX "" 
		COMPILE_FLAGS "-DMEX"
	)
	# general libraries
	TARGET_LINK_LIBRARIES("${FN}.${MATLAB_MEX_SUFFIX}" ${MATLAB_LIBRARIES} bdm itpp)
	# platform specific libraries
	IF(WIN32)
		target_link_libraries ("${FN}.${MATLAB_MEX_SUFFIX}" libacml_dll)
 	ELSE(WIN32)
 		IF(APPLE)
 			target_link_libraries ("${FN}.${MATLAB_MEX_SUFFIX}" ${FRAMEWORK_VECLIB})
 		ENDIF(APPLE)
 	ENDIF(WIN32)
	## Additional libraries can be added to a macro
	target_link_libraries ("${FN}.${MATLAB_MEX_SUFFIX}" ${ARGN}) 
	ENDIF(MEX_COMPILER)
ENDMACRO(MEX)
