#include "egiw_harness.h"
#include "stat/exp_family.h"
#include "mat_checks.h"
#include "test_util.h"
#include "UnitTest++.h"

const double epsilon = 0.00001;

namespace UnitTest
{

inline void CheckClose(TestResults &results, const itpp::vec &expected,
		       const itpp::vec &actual, double tolerance,
		       TestDetails const &details) {
    if (!AreClose(expected, actual, tolerance)) { 
        MemoryOutStream stream;
        stream << "Expected " << expected << " +/- " << tolerance << " but was " << actual;

        results.OnTestFailure(details, stream.GetText());
    }
}

inline void CheckClose(TestResults &results, const itpp::mat &expected,
		       const itpp::mat &actual, double tolerance,
		       TestDetails const &details) {
    if (!AreClose(expected, actual, tolerance)) { 
        MemoryOutStream stream;
        stream << "Expected " << expected << " +/- " << tolerance << " but was " << actual;

        results.OnTestFailure(details, stream.GetText());
    }
}

}

namespace bdm {

template<>
const ParticularUI<egiw_harness> &ParticularUI<egiw_harness>::factory(
    ParticularUI<egiw_harness>("egiw_harness"));

void egiw_harness::from_setting(const Setting &set) {
    epdf_harness::from_setting(set);
    UI::get(lognc, set, "lognc");
}

void egiw_harness::test()
{
    epdf_harness::test();

    egiw *wide = dynamic_cast<egiw *>(get_epdf());
    CHECK(wide);

    CHECK_CLOSE(lognc, wide->lognc(), epsilon);
}

}
