#define BDMLIB // not an ideal way to prevent double registration of UI factories...
#include "base/bdmbase.h"
#include "base/user_info.h"
#include "stat/exp_family.h"
#include "itpp_ext.h"
#include "epdf_harness.h"
#include "egiw_harness.h"
#include "mat_checks.h"
#include "UnitTest++.h"

const double epsilon = 0.00001;

namespace UnitTest
{

inline void CheckClose(TestResults &results, const itpp::vec &expected,
		       const itpp::vec &actual, double tolerance,
		       TestDetails const &details) {
    if (!AreClose(expected, actual, tolerance)) { 
        MemoryOutStream stream;
        stream << "Expected " << expected << " +/- " << tolerance << " but was " << actual;

        results.OnTestFailure(details, stream.GetText());
    }
}

}

using namespace bdm;

template<>
const ParticularUI<egamma> &ParticularUI<egamma>::factory(
    ParticularUI<egamma>("egamma"));

TEST(test_egamma) {
    RV::clear_all();
    UIFile in("egamma.cfg");
    Array<epdf_harness *> input;
    UI::get(input, in, "data");
    int sz = input.size();
    CHECK(sz > 0);
    for (int i = 0; i < sz; ++i) {
        input(i)->test();
    }
}
