/*!
  \file
  \brief Support for testing descendants of epdf.
  \author Vaclav Barta.

  -----------------------------------
  BDM++ - C++ library for Bayesian Decision Making under Uncertainty

  Using IT++ for numerical operations
  -----------------------------------
*/

#ifndef EPDF_HARNESS_H
#define EPDF_HARNESS_H

#define BDMLIB // not an ideal way to prevent double registration of UI factories...

#include "bdmroot.h"
#include "itpp_ext.h"
#include "shared_ptr.h"
#include "base/bdmbase.h"
#include "base/user_info.h"

namespace bdm
{

class epdf_harness : public root
{
private:
    shared_ptr<epdf> hepdf;
    vec mean;
    vec variance;
    mat support;
    vec nbins;
    int nsamples;
    double integral;
    mat R;

public:
    epdf_harness():nsamples(1000), integral(0) { }

    virtual void test();

    void from_setting(const Setting &set);

protected:
    epdf *get_epdf() { return hepdf.get(); }
};

}

#endif
