#define BDMLIB // not an ideal way to prevent double registration of UI factories...
#include "stat/exp_family.h"
#include "epdf_harness.h"
#include "mat_checks.h"
#include "test_util.h"
#include "UnitTest++.h"

using namespace bdm;

const double epsilon = 0.00001;

namespace UnitTest
{

inline void CheckClose(TestResults &results, const itpp::vec &expected,
		       const itpp::vec &actual, double tolerance,
		       TestDetails const& details) {
    if (!AreClose(expected, actual, tolerance)) { 
        MemoryOutStream stream;
        stream << "Expected " << expected << " +/- " << tolerance << " but was " << actual;

        results.OnTestFailure(details, stream.GetText());
    }
}

inline void CheckClose(TestResults &results, const itpp::mat &expected,
		       const itpp::mat &actual, double tolerance,
		       TestDetails const& details) {
    if (!AreClose(expected, actual, tolerance)) { 
        MemoryOutStream stream;
        stream << "Expected " << expected << " +/- " << tolerance << " but was " << actual;

        results.OnTestFailure(details, stream.GetText());
    }
}

}

template<>
const ParticularUI<enorm<ldmat> > &ParticularUI<enorm<ldmat> >::factory(
    ParticularUI<enorm<ldmat> >("enorm<ldmat>"));

template<>
const ParticularUI<enorm<fsqmat> > &ParticularUI<enorm<fsqmat> >::factory(
    ParticularUI<enorm<fsqmat> >("enorm<fsqmat>"));

 template<>
const ParticularUI<enorm<chmat> > &ParticularUI<enorm<chmat> >::factory(
    ParticularUI<enorm<chmat> >("enorm<chmat>"));

TEST(test_enorm) {
    RV::clear_all();
    UIFile in("enorm.cfg");
    Array<epdf_harness *> input;
    UI::get(input, in, "data");
    int sz = input.size();
    CHECK(sz > 0);
    for (int i = 0; i < sz; ++i) {
        input(i)->test();
    }
}
