#include "epdf_harness.h"
#include "base/bdmbase.h"
#include "base/user_info.h"
#include "stat/exp_family.h"
#include "mat_checks.h"
#include "test_util.h"
#include "UnitTest++.h"

namespace bdm {

template<>
const ParticularUI<epdf_harness> &ParticularUI<epdf_harness>::factory(
    ParticularUI<epdf_harness>("epdf_harness"));

void epdf_harness::test_config(const char *config_file_name) {
    RV::clear_all();

    UIFile in(config_file_name);
    Array<epdf_harness *> input;
    UI::get(input, in, "data");
    int sz = input.size();
    CHECK(sz > 0);
    for (int i = 0; i < sz; ++i) {
        input(i)->test(config_file_name, i);
    }
}

void epdf_harness::from_setting(const Setting &set) {
    hepdf = UI::build<epdf>(set, "epdf");
    UI::get(mean, set, "mean");
    UI::get(variance, set, "variance");

    if (set.exists("support")) {
        UI::get(support, set, "support");
    }

    if (set.exists("nbins")) {
        UI::get(nbins, set, "nbins");
    }

    if (set.exists("nsamples")) {
        UI::get(nsamples, set, "nsamples");
    }

    if (set.exists("R")) {
        UI::get(R, set, "R");
    }

    if (set.exists("tolerance")) {
        UI::get(tolerance, set, "tolerance");
    }
}

void epdf_harness::test(const char *config_name, int idx)
{
    CurrentContext cc(config_name, idx);

    CHECK_CLOSE_EX(mean, hepdf->mean(), tolerance);
    CHECK_CLOSE_EX(variance, hepdf->variance(), tolerance);

    if (support.rows() == 2) {
	vec xb = support.get_row(0);
	vec yb = support.get_row(1);

	int old_size = nbins.size();
	if (old_size < 2) {
	    vec new_nbins("100 100");
	    for (int i = 0; i < old_size; ++i) {
	        new_nbins(i) = nbins(i);
	    }

	    nbins = new_nbins;
	}

	CHECK_CLOSE_EX(mean, num_mean2(hepdf.get(), xb, yb, nbins(0), nbins(1)), 0.1);
	CHECK_CLOSE_EX(1.0, normcoef(hepdf.get(), xb, yb, nbins(0), nbins(1)), 0.1);
    }

    if (R.rows() > 0) {
	mat smp = hepdf->sample_m(nsamples);
	int n = smp.cols();
	vec emu = smp * ones(n) / n;
	mat er = (smp * smp.T()) / n - outer_product(emu, emu);
	CHECK_CLOSE_EX(mean, emu, tolerance);
	CHECK_CLOSE_EX(R, er, tolerance);
    }
}

}
